/*
Copyright (C) 2010 Edge-Core Networks
This software file (the "File") is owned and distributed by 
Edge-Core Networks under the following licensing terms.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston,
MA 02111-1307 USA
*/

#ifndef _AMS_COMMON_H_
#define _AMS_COMMON_H_

#include "accton_board.h"
#include "ams_lib.h"

#define FALSE 0
#define TRUE  1

typedef int BOOL;

#define AMS_DEBUG

#ifdef AMS_DEBUG

#define AMS_HALT()          \
    do {                    \
        for (;;);           \
    } while(0);

#define AMS_ASSERT(cond, msg)                  \
    do {                                       \
        if (cond)                              \
        {                                      \
            printf("<4>line %d of file %s:%s", \
                __LINE__, __FILE__, msg);      \
            AMS_HALT();                        \
        }                                      \
    } while(0);

#define AMS_PRINTK printf

#else

#define AMS_ASSERT(cond, msg) 
#define AMS_PRINTK 

#endif

#define RC_PARAMENT_ERROR       -2
#define RC_ERROR                -1
#define RC_OK                    0
#define RC_PART_CHECK_ERROR	     1
#define RC_PART_NUMBER_EXCEED    2
#define RC_PART_DO_NOT_EXIST     3

#define SYS_ADPT_MAC_ADDR_LEN                           6
#define SYS_ADPT_SERIAL_NO_STR_LEN                      21  /* max 21 chars, example: ACTyywwnnnn */
#define SYS_ADPT_HW_VER_STR_LEN                         5   /* max 5 chars, example: R01A         */
#define SYS_ADPT_MANUFACTURE_DATE_LEN                   10  /* eg. 2001-11-09                     */
#define SYS_ADPT_RESERVED_INFO_LEN                      32
#define SYS_ADPT_MODEL_NUMBER_LEN                       15  /* max 15 chars, example: ES3508A-B3  */
#define SYS_ADPT_MAX_PASSWORD_LEN                       32
#define SYS_ADPT_FW_VER_STR_LEN                     11  /* max 11 chars, example: 1.02.23.01  */
#define SYS_ADPT_LOADER_CUSTOMIZED_VER_STR_LEN      SYS_ADPT_FW_VER_STR_LEN
#define SYS_ADPT_POST_CUSTOMIZED_VER_STR_LEN        SYS_ADPT_FW_VER_STR_LEN
#define SYS_ADPT_FW_CUSTOMIZED_VER_STR_LEN          SYS_ADPT_FW_VER_STR_LEN
#define SYS_ADPT_KERNEL_VER_STR_LEN                 19  /* max 19 chars, example: 2.6.19.2-1-1.1 */
#define SYS_ADPT_FILE_SYSTEM_NAME_LEN                           32

#define BOOL_T       unsigned char
#define I8_T         signed char          /* signed  8 bit integer  */
#define UI8_T        unsigned char        /* unsigned 8 bit integer  */
#define I16_T        short                /* signed  16 bit integer */
#define UI16_T       unsigned short       /* unsigned 16 bit integer */
#define I32_T        long                 /* signed  32 bit integer */
#define UI32_T       unsigned long        /* unsigned 32 bit integer */
typedef UI32_T       FS_File_Type_T;
/*typedef*/ enum FS_File_Type_E
{
    FS_FILE_TYPE_SUBFILE    = 0,
    FS_FILE_TYPE_KERNEL,
    FS_FILE_TYPE_DIAG,
    FS_FILE_TYPE_RUNTIME,
    FS_FILE_TYPE_SYSLOG,
    FS_FILE_TYPE_CMDLOG,
    FS_FILE_TYPE_CONFIG,
    FS_FILE_TYPE_POSTLOG,
    FS_FILE_TYPE_PRIVATE,
    FS_FILE_TYPE_CERTIFICATE,
    FS_FILE_TYPE_ARCHIVE,
    FS_FILE_TYPE_BINARY_CONFIG,
    FS_FILE_TYPE_PUBLIC,
    FS_FILE_TYPE_CPEFIRMWARE,
    FS_FILE_TYPE_CPECONFIG,
    FS_FILE_TYPE_FILEMAPPING,
    FS_FILE_TYPE_NAND_ECC_UPGRADE,
    FS_FILE_TYPE_NAND_ECC_DOWNGRADE,
    FS_FILE_TYPE_TOTAL      /* Number of total file type */
} /*FS_File_Type_T*/;

#endif

